      PROGRAM Test
      INCLUDE 'mkl_dss.f77'

      INTEGER tIU(:), tJU(:), Idum(1), ITER
      DOUBLE PRECISION tUM(:), tXDIFF(:), tX(:)
      ALLOCATABLE tIU, tJU, tUM, tXDIFF, tX
      
      INTEGER nNonZeros,nRow
      
      INTEGER*8 handle
      INTEGER error

      OPEN (UNIT=10, FILE='testInfo.dat') 
      READ (10,7004) nNonZeros, nRow
      CLOSE(10)
    
      ALLOCATE(tIU(nRow+1))
      ALLOCATE(tXDIFF(nRow))
      ALLOCATE(tX(nRow))
      ALLOCATE(tJU(nNonZeros))
      ALLOCATE(tUM(nNonZeros))

      
      OPEN (UNIT=10, FILE='columns.dat') 
      READ (10,7002) (tJU(II),II=1,nNonZeros)
      CLOSE(10)
      
      OPEN (UNIT=10, FILE='rowIndex.dat') 
      READ (10,7002) (tIU(II),II=1,nRow+1)
      CLOSE(10)
      
      OPEN (UNIT=10, FILE='values.dat') 
      READ (10,7001) (tUM(II),II=1,nNonZeros)
      CLOSE(10)
      
      OPEN (UNIT=10, FILE='loadVector.dat')
      READ (10,7001) (tXDIFF(II),II=1,nRow)
      CLOSE(10)   
      


      ITER=1
C---------------------------------------------------------------------------
C Initialize the solver
C---------------------------------------------------------------------------
      error = dss_create(handle, MKL_DSS_DEFAULTS+MKL_DSS_OOC_VARIABLE)
      IF (error .NE. MKL_DSS_SUCCESS ) GOTO 999
C---------------------------------------------------------------------------

C---------------------------------------------------------------------------
C Define the non-zero structure of the matrix
C---------------------------------------------------------------------------
         !    error = dss_define_structure( handle, MKL_DSS_SYMMETRIC,
         !& tIU, nRow, nRow, tJU, nNonZeros )
        error = dss_define_structure( handle, MKL_DSS_NON_SYMMETRIC,
     & tIU, nRow, nRow, tJU, nNonZeros )
      IF (error .NE. MKL_DSS_SUCCESS ) GOTO 999
C---------------------------------------------------------------------------

C---------------------------------------------------------------------------
C Reorder the matrix
C---------------------------------------------------------------------------

      IF (ITER.EQ.1) THEN
          error = dss_reorder( handle, MKL_DSS_GET_ORDER, Idum)
          IF (error .NE. MKL_DSS_SUCCESS ) GOTO 999
      ELSE
          error = dss_reorder( handle, MKL_DSS_MY_ORDER, Idum)
          IF (error .NE. MKL_DSS_SUCCESS ) GOTO 999
      ENDIF

C---------------------------------------------------------------------------
C Factor the matrix
C---------------------------------------------------------------------------
      error = dss_factor_real( handle, MKL_DSS_DEFAULTS, tUM)
      IF (error .NE. MKL_DSS_SUCCESS ) GOTO 999
      
C---------------------------------------------------------------------------
C Get the solution vector
C---------------------------------------------------------------------------
      error = dss_solve_real( handle, MKL_DSS_DEFAULTS,
     & tXDIFF, 1, tX)
      IF (error .NE. MKL_DSS_SUCCESS ) GOTO 999
C---------------------------------------------------------------------------
     
C---------------------------------------------------------------------------
C Deallocate solver storage
C---------------------------------------------------------------------------
      error = dss_delete( handle, MKL_DSS_DEFAULTS )
      IF (error .NE. MKL_DSS_SUCCESS ) GOTO 999
C---------------------------------------------------------------------------

      OPEN (UNIT=10, FILE='OutValues.dat') 
      WRITE (10,7005) (tX(II),II=1,nRow)
      CLOSE(10)
      GOTO 1999
      
7001  FORMAT(1X,D)     
7002  FORMAT(1X,I5)
7003  FORMAT(1X,I,1X,D)
7004  FORMAT(1X,I,1X,I)
7005  FORMAT(1X,D)
      
999   WRITE(*,*) "Solver returned error code ", error
      
1999  DEALLOCATE(tIU,tJU,tUM,tXDIFF,tX)
      
      END
      
      
