#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <SDL.h>

#define		REPERE		    (PITCH * (WIDTH/2 - 1)) + (BPP * (LENGTH/2 - 1))
#define		BPP			    4
#define		LENGTH		    800     // x
#define		WIDTH		    600     // y
#define     DEPTH           800     // z
#define		PITCH		    LENGTH * BPP
#define		WHITE		    0x00FFFFFF
#define		RED		        0x00FF0000
#define		GREEN           0x0000FF00
#define		BLUE            0x000000FF
#define		DEGTORAD(angle) angle * 0.017453292  // angle * PI/180
#define		RAPPORT			(LENGTH/WIDTH)
#define		FOCALE          800
#define		PROFONDEUR      2000

SDL_Surface *screen;
float   rotation_x, rotation_y, rotation_z;
float   translate_x, translate_x_y, translate_x_z;
    asm ("       jmp        skip_data           \n"
         "       translation:   .long   0       \n"
         "       translation_x:	.long   0       \n"
         "       translation_y:	.long   0       \n"
         "       translation_z:	.long   0       \n"
         "                      .long   0       \n"         //; reserved: color

         "    angle:            .long   0       \n"
         "        rotation_x:   .long   0       \n"
         "        _xmm0:        .long   0       \n"			//; sin.x	0
         "                      .long   1,0     \n"			//; cos.x	4
         "                      .long   1,0     \n"			//; cos.x	8
         "                      .long   0       \n"			//; sin.x	12
         "                      .long   1,0     \n"			//; 1		16
         "                      .long   0       \n"			//; sin.y	20

         "        rotation_z:   .long	0       \n"
         "        _xmm1:        .long	0       \n"			//; sin.z	0
         "                      .long	1,0     \n"			//; cos.z 4
         "                      .long   1,0      \n"			//; cos.z	8
         "                      .long   0        \n"			//; sin.z	12
         "                      .long	1,0     \n"			//; 1		16
         "                      .long   0        \n"			//; sin.y	20

         "        rotation_y:   .long	0       \n"
         "        _xmm2:        .long   0        \n"			//; sin.y	0
         "                      .long   1,0      \n"			//; cos.y 4
         "                      .long   1,0      \n"			//; cos.y 8
         "                      .long   0        \n"			//; sin.y	12
         "                      .long   1,0      \n"			//; 1		16
         "                      .long   0        \n"			//; sin.y	20

         "    color_pixel:		.long	0       \n"
         "    coordonee:                        \n"
         "            x:		.long	0       \n"
         "            y:		.long	0       \n"
         "            z:		.long	0       \n"
         "                      .long	0       \n"			//; reserved: color
         "            _x:       .long	0       \n"
         "            _y:       .long   0       \n"

         "   conv_signe:        .long   -0,0        \n"
         "   rapport:           .long	1,3333333   \n"
         "    skip_data:                            \n"
			 );
/*
void        asm2add()
{
    asm (
        //;=============
		// yaw
		//=============
                // y
				// On applique la rotation au point	|[esi + 0] = x
				//									|[esi + 4] = y
				//									|[esi + 8] = z
				// On calcule x = x.cos(phi.y) * cos(phi.z) - y.cos(phi.y) * sin(phi.z) - z.sin(phi.y)
				//
				// On calcule  A = x.cos(phi.y), B = y.cos(phi.y) et C = z.sin(phi.y)
		"			movups	xmm0, [_xmm2 + 4]       \n"
		"			movups	xmm1, [coordonee]       \n"
		"			mulps	xmm0, xmm1              \n"

				// On calcule D = A * cos(phi.z), E = B * sin(phi.z) et C = C * 1
		"			movups	xmm1, [_xmm1 + 8]       \n"
		"			mulps	xmm0, xmm1              \n"

				// On calcule F = D - E, C = C - 0
		"			hsubps	xmm0, xmm0              \n"

				// On calcule xmm0 = F - C
		"			hsubps	xmm0, xmm0              \n"

				// On modifie x selon selon le rapport entre x et y pour que x soit proportionnelle  y
		"			movd	xmm1, [rapport]         \n"
		"			divps	xmm0, xmm1              \n"

				// On save la new coordone
		"			movd	[_x], xmm0              \n"

		//=============
		// / yaw
		//=============

		//=============
		// pitch
		//=============
                // x
				// On applique la rotation au point	|[esi + 0] = x
				//									|[esi + 4] = y
				//									|[esi + 8] = z
				// On calcule y = x.(cos(phi.x) * sin(phi.z) - sin(phi.x) * cos(phi.z) * sin(phi.y)) +
				//				 y.(sin(phi.x) * sin(phi.z) * sin(phi.y) + cos(phi.x) * cos(phi.z)) -
				//				 z.(sin(phi.x) * cos(phi.y))
				//
				// On calcule A = cos(phi.x) * sin(phi.z), B = sin(phi.x) * cos(phi.z), E = cos(phi.x) * cos(phi.z) et F = sin(phi.x) * sin(phi.z)
		"			movddup xmm0, [_xmm0 + 8]       \n"
		"			movups 	xmm1, [_xmm1]           \n"
		"			mulps	xmm0, xmm1              \n"

				// on sauve xmm0 dans xmm7 pour le copier dans xmm0 de Roll car l'equation de y ressemblent a l'equation de z mis a part que la valeur sin(phi.y) est
				// multipli par d'autres equations

				// On calcule C' = A' * sin(phi.y) et G' = E' * sin(phi.y)
		"			movddup	xmm7, [_xmm2 + 12]       \n"
		"			mulps	xmm7, xmm0              \n"

				// On calcule C = B * sin(phi.y) et G = F * sin(phi.y)
		"			movddup	xmm2, [_xmm2 + 16]      \n"
		"			mulps	xmm0, xmm2              \n"

				// Copie le contenu du haut (64..127) d'un paquet de valeurs rel de simple prcision (4*32 bits) dans sa partie basse (0..31).
				// En somme on separe les deux partie x et y:	xmm0 =	A) cos(phi.x) * sin(phi.z)								xmm0 =	cos(phi.x) * sin(phi.z)
				//											 			C) sin(phi.x) * cos(phi.z) * sin(phi.y) 			=>			sin(phi.x) * sin(phi.y) * cos(phi.z)
				//														E) cos(phi.x) * cos(phi.z)								xmm1 =	cos(phi.x) * cos(phi.z)
				//														G) sin(phi.x) * sin(phi.z) * sin(phi.y)							sin(phi.x) * sin(phi.y) * sin(phi.z)
		"			movhlps xmm1, xmm0          \n"

				// On calcule D = A - C
		"			hsubps xmm0, xmm0           \n"

				// On calcule H = E + G
		"			haddps xmm1, xmm1           \n"

				// On calcule sin(phi.x) * cos(phi.y) et cos(phi.x) * cos(phi.y)
				//
				// On calcule I.roll = cos(phi.x) * cos(phi.y) et I.Pitch = sin(phi.x) * cos(phi.y)
		"			movlps		xmm3, [_xmm0 + 8]       \n"
		"			movlps		xmm2, [_xmm2 + 4]       \n"
		"			mulps		xmm2, xmm3              \n"
		"			movshdup 	xmm3, xmm2              \n"
				// On calcule x.D + y.H - z.I
				//
				// On calcule J = x.D, K = y.H et L = z.I
		"			movups		xmm5, [coordonee]       \n"
		"			movsldup	xmm4, xmm1              \n"    //; y.H
		"			movss		xmm4, xmm0              \n"    //; x.D
		"			movlhps 	xmm4, xmm3              \n"    //; z.I.Pitch
		"			mulps		xmm4, xmm5              \n"

				// On calcule M = J + K
		"			haddps	xmm4, xmm4       \n"

				// On calcule N = M - L
		"			hsubps	xmm4, xmm4       \n"

				// On save la new coordone
		"			movd	[_y], xmm4       \n"

		//=============
		// / pitch
		//=============
		//=============
		// roll
		//=============
                // z
				// On applique la rotation au point	|[esi + 0] = x
				//									|[esi + 4] = y
				//									|[esi + 8] = z
				// On calcule z' = x.(cos(phi.x) * cos(phi.z) * sin(phi.y) + sin(phi.x) * sin(phi.z)) +
				//				  y.(sin(phi.x) * cos(phi.z) - cos(phi.x) * sin(phi.z) * sin(phi.y)) +
				//				  z.(cos(phi.x) * cos(phi.y))
				//
				// Copie le contenu du haut (64..127) d'un paquet de valeurs rel de simple prcision (4*32 bits) dans sa partie basse (0..31).
				// En somme on separe les deux partie x et y:	xmm7 =	C') cos(phi.x) * sin(phi.z) * sin(phi.y)				xmm7 =	C') cos(phi.x) * sin(phi.z) * sin(phi.y))
				//											 			B') sin(phi.x) * cos(phi.z)						 =>				B') sin(phi.x) * cos(phi.z)
				//														G') cos(phi.x) * cos(phi.z) * sin(phi.y)				xmm1 =	G') cos(phi.x) * cos(phi.z) * sin(phi.y)
				//														F') sin(phi.x) * sin(phi.z)										F') sin(phi.x) * sin(phi.z
		"			movhlps xmm1, xmm7          \n"

				// On calcule D' = -B' + C'
		"			movd	xmm6, [conv_signe]  \n"
		"			orps	xmm7, xmm6          \n"
		"			haddps	xmm7, xmm7          \n"

				// On calcule H' = G' + F'
		"			haddps	xmm1, xmm1          \n"

				// On calcule x.D' + y.H' + z.I'
				//
				// On calcule J = x.D', K = y.H' et L = z.I'
		"			movups		xmm3, [coordonee]       \n"
		"			movsldup	xmm4, xmm7              \n"    // y.D'
		"			movss		xmm4, xmm1              \n"    // x.H'
		"			movlhps 	xmm4, xmm2              \n"    // z.I'
		"			mulps		xmm4, xmm3              \n"

				// On calcule M' = J' + K'
		"			haddps	xmm4, xmm4       \n"

				// On calcule N' = M' + L'
		"			haddps	xmm4, xmm4       \n"
		//=============
		// / roll
		//=============
			 );
}
*/

void        put_pixel(float x, float y, float z, int pixel)
{
    float   x_end;
    float   y_end;
    float   z_end;
    int     *ptr_pixel;

    float   cx = cos(DEGTORAD(rotation_x));
    float   cy = cos(DEGTORAD(rotation_y));
    float   cz = cos(DEGTORAD(rotation_z));
    float   sx = sin(DEGTORAD(rotation_x));
    float   sy = sin(DEGTORAD(rotation_y));
    float   sz = sin(DEGTORAD(rotation_z));

    x_end = x * ((cy * cz))                       - y * ((cy * sz))                        - z * (sy)     ;
    y_end = x * ((cx * sz)      - (sx * sy * cz)) + y * ((sx * sy * sz) + (cx * cz))       - z * (sx * cy);
    z_end = x * ((cx * sy * cz) + (sx * sz))      + y * ((sx * cz)      - (cx * sy * sz )) + z * (cx * cy);

    x = x_end / RAPPORT;
    y = y_end;
    z = z_end;

    x = (x * FOCALE) / (z + PROFONDEUR);
    y = (y * FOCALE) / (z + PROFONDEUR);

    ptr_pixel = screen->pixels + REPERE - screen->pitch * (int)y + (int)x * BPP;

    if (ptr_pixel > screen->pixels && ptr_pixel < (screen->pixels + LENGTH*WIDTH * BPP))
        if ((x <= LENGTH/2 && x >= -LENGTH/2) && (y <= WIDTH/2 && y >= -WIDTH/2))
            *(ptr_pixel) = pixel;
}
/*
void        trace_circle(float rayon)
{
    float   x, y, angle_circle;

    angle_circle = 0;
    x = 0;
    y = 0;
    while(angle_circle <= 360)
    {
            angle_circle+=0.1;
            x = cos(DEGTORAD(angle_circle)) * rayon;
            y = sin(DEGTORAD(angle_circle)) * rayon;
        put_pixel(x, y, 0, WHITE);
    }

		 rayon = 200;
		 x = -rayon;
		 while(x <= rayon)
		 {
			; y = (rayon * rayon) - (x * x);
			; PutPixel(x, sqrt(y), BLANC);
			; PutPixel(x, -sqrt(y), BLANC);
			; SDL_Flip(screen);
			; x+=0.001;
		 }
    *//*
}

void        trace_droite2D(float lenght)
{
    float   x, y, a, b, c;

    a = b = c = 1;
    x = -lenght;
    while(x <= lenght)
    {
        y = -((a * x + c)/b);

        put_pixel(x, y, 0, WHITE);
        x+=0.1;
    }
}

void        rotation_2D(float *object, int size, float yangle_add,
                                                float xangle_add,
                                                float zangle_add)
{
    float   x, rayon, xangle_point,
            y,        yangle_point,
            z,        zangle_point;
    int     indice = 0;

    while(indice != size)
    {
        x = object[indice];
        y = object[indice + 1];
        z = object[indice + 2];

        rayon = sqrt(x * x + y * y + z * z);
        xangle_point = acos(x/rayon);
        yangle_point = asin(y/rayon);
        zangle_point = asin(z/rayon);

        x = rayon * cos(xangle_point + xangle_add);
        y = rayon * sin(yangle_point + yangle_add);
        z = rayon * sin(zangle_point + zangle_add);
        if (zangle_add !=0)
        {
            x = rayon * cos(xangle_point + zangle_add);
            y = rayon * sin(xangle_point + zangle_add);
        }
        put_pixel(x, y, z, WHITE);
        put_pixel(-x, -y, -z, WHITE);

        indice+=3;
    }
}
*/
void    put_object(float *object, int size)
{
    while (size--)
    {
        put_pixel(*(object + 0), *(object + 1), *(object + 2), *(object + 3));
        object+=4;
    }
}

void    reset_phi()
{
    if (rotation_x >= 360)
        rotation_x = 0;

    if (rotation_y >= 360)
        rotation_y = 0;

    if (rotation_z >= 360)
        rotation_z = 0;
}

void        scale_object(float *object, int size_object, float size_scale)
{
    while(size_object--)
    {
        *(object + 0) *= size_scale;    //x
        *(object + 1) *= size_scale;    //y
        *(object + 2) *= size_scale;    //z
        object += 4;
    }
}

void        make_voxel_cube(float *cube, float size)
{
    float   x, y, z;
    float   cote_voxel_cube = size;
    int     indice;

    x = cote_voxel_cube;
    indice = 0;
    while (x > -cote_voxel_cube) //fill_cube_volume
    {
        y = cote_voxel_cube;
        while (y > -cote_voxel_cube) //fill_cube_surface
        {
            z = cote_voxel_cube;
            while (z > -cote_voxel_cube) //fill_cube_line
            {
                cube[indice + 0] = x * 20;
                cube[indice + 1] = y * 20;
                cube[indice + 2] = z * 20;
                cube[indice + 3] = BLUE ;
                indice+=4;
                z--;
            }
            y--;
        }
        x--;
    }
}

void        make_repere(float *repere)
{
    float   x, y, z;
    int     indice;

    x = -(LENGTH/2);
    y = -(WIDTH/2);
    z = -(DEPTH/2);
    indice = 0;
    while(x < LENGTH/2)
    {
        repere[indice + 0] = x++;
        repere[indice + 1] = 0;
        repere[indice + 2] = 0;
        repere[indice + 3] = WHITE;
        indice +=4;
    }

    while(y < WIDTH/2)
    {
        repere[indice + 0] = 0;
        repere[indice + 1] = y++;
        repere[indice + 2] = 0;
        repere[indice + 3] = GREEN;
        indice +=4;
    }

    while(z < DEPTH/2)
    {
        repere[indice + 0] = 0;
        repere[indice + 1] = 0;
        repere[indice + 2] = z++;
        repere[indice + 3] = RED;
        indice +=4;
    }
}

int         main( int argc, char *argv[ ] )
{
    int     start_time = 0;
    int     current_time = 0;
    int     compteur_boucle = 0;
    int     fps = 0;
    int     size_object;

    //# File exported by ZBrush version 4.5
    static float    voxel_rhino[13998*4]= {
                                                #include "Rhino.obj"
                                            };
    static float    voxel_cube[50*50*50*4];
    static float    repere[(LENGTH + WIDTH + DEPTH) * 4];
    static float    cube[8*4]= {  /// Fae avant du cube
                                ///		   X	   Y       Z 	 color
                                        -100.0, -100.0,  100.0,  WHITE  /// Le point en haut  gauche de la fae avant du cube
                                ,		-100.0,  100.0,  100.0,  WHITE  /// Le point en bas  gauche de la fae avant du cube
                                ,		 100.0, -100.0,  100.0,  WHITE  /// Le point en bas  droite de la fae avant du cube
                                ,		 100.0,  100.0,  100.0,  WHITE  /// Le point en haut  droite de la fae avant du cube
                                /// Fae arriere du cube
                                ,		-100.0, -100.0, -100.0,  WHITE  /// Le point en haut  gauche de la fae arriere du cube
                                ,		-100.0,  100.0, -100.0,  WHITE  /// Le point en bas  gauche de la fae arriere du cube
                                ,		 100.0, -100.0, -100.0,  WHITE  /// Le point en haut  droite de la fae arriere du cube
                                , 		 100.0,  100.0, -100.0,  WHITE  /// Le point en bas  droite de la fae arriere du cube
                              };

    freopen("CON", "w", stdout);
    freopen("CON", "r", stdin);
    freopen("CON", "w", stderr);

    SDL_Init( SDL_INIT_VIDEO );
    atexit( SDL_Quit );
    screen = SDL_SetVideoMode( LENGTH, WIDTH, 32, SDL_HWSURFACE );

    make_voxel_cube(voxel_cube, 25);
    make_repere(repere);
    scale_object(voxel_rhino, 13997, 450);

    rotation_x = rotation_y = rotation_z = 0;
    start_time = SDL_GetTicks();
    size_object = 13997;
    while (1)
    {
        rotation_x--;
        rotation_z++;
        reset_phi();

        //put_object(repere, LENGTH + WIDTH + DEPTH);
//        put_object(voxel_rhino, size_object);
        put_object(voxel_cube, 50*50*50);

        SDL_Flip(screen);
        SDL_FillRect(screen,NULL,0);

        calculate_fps:
            current_time = SDL_GetTicks();
            if (current_time - start_time >= 1000)
            {
                fps = compteur_boucle;
                compteur_boucle = 0;
                start_time = SDL_GetTicks();
            }
            else
                compteur_boucle++;
            printf("FPS = %d\n", fps);
    }

    return EXIT_SUCCESS;
}
/*
void    create_window()
{
        asm("xorl %eax, %eax        \n"
            "xorl %ebx, %ebx        \n"
            "xorl %ecx, %ecx        \n"
            "xorl %edx, %edx        \n"
            "pushl %ecx             \n" //$0x0
            "pushl $0x20206c6c      \n" //"  ll"
            "pushl $0x642e3233      \n" //"d.23"
            "pushl $0x72657375      \n" //"resu"
            "movl %esp, %ecx        \n" //store "user32.dll" address in %ecx
            "movl $0x7c801d7b, %ebx \n" //store address of LoadLibraryA in %ebx
            "pushl %ecx             \n"
            "call *%ebx             \n"
            "movl $0xef30675e, %ecx \n"
            "addl $0x11111111, %ecx \n"
            "pushl %ecx             \n"
            "pushl $0x42656761      \n"
            "pushl $0x7373654d      \n"
            "movl %esp, %ecx        \n"
            "pushl %ecx             \n"
            "pushl %eax             \n"
            "movl $0x7c80ae40, %ebx \n"
            "call *%ebx             \n"
            "movl %esp, %ecx        \n"
            "xorl %edx, %edx        \n"
            "pushl %edx             \n"
            "pushl %ecx             \n"
            "pushl %ecx             \n"
            "pushl %edx             \n"
            "call *%eax             \n"
            "xorl %eax, %eax        \n"
            "pushl %eax             \n"
            "movl $0x7c81cb12, %eax \n"
            "call *%eax             \n"
            );
}
*/
