// include the basic windows header file
#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <time.h>

#define		REPERE		    (LENGTH * (WIDTH/2 - 1)) + ((LENGTH/2 - 1))
#define		BPP			    4
#define		LENGTH		    1024     // x
#define		WIDTH		    800     // y
#define     DEPTH           800     // z
#define		PITCH		    LENGTH * BPP
#define		WHITE		    0x00FFFFFF
#define		RED		        0x00FF0000
#define		GREEN           0x0000FF00
#define		BLUE            0x000000FF
#define		BLACK			0x00000000
#define		DEG2RAD(angle)  angle * 0.017453292  // PI/180
#define		RAPPORT			(LENGTH/WIDTH)
#define		FOCALE          800
#define		PROFONDEUR      2000
#define		__x				0
#define		__y				4
#define		__z				8
#define		_x				0
#define		_y				1
#define		_z				2

float			rotation_object[4] = { 0 };     // 0: x , 1: y , 2: z
float			translate_object[4] = { 0 };    // 0: x , 1: y , 2: z
float           repere_object2[4] = { 0 };
float           repere_object[4] = { 0 };
static int		screen[LENGTH*WIDTH] = {BLACK};

HINSTANCE		instance;
HBITMAP			texture;
PAINTSTRUCT 	paint_struct;
HDC 			device_context_screen;
HDC 			device_context_texture;

WNDCLASS		windows_class;
HWND			windows_handle;
MSG				event;

//static float    voxel_cube[498 * 498 * 498 * 4] = { 0 };

/*
void __declspec(naked) make_rotation(char pVideoMode)
{
// Naked functions must provide their own prolog...
char m = pVideoMode;
__asm{
mov ah, 00h
mov al, m
int 0x10
}
}
*/
typedef struct _trigo
{
	float	cos[4];
	float	sin[4];
	float	*coord;
	float	end_coord[4];

}_trigo;
struct _trigo	trigo;

void        put_pixel(float *coord, int color, float* a)
{
	int		offset_pixel;

	trigo.coord = coord;

	trigo.cos[_x] = cos(DEG2RAD(rotation_object[_x]));
	trigo.cos[_y] = cos(DEG2RAD(rotation_object[_y]));
	trigo.cos[_z] = cos(DEG2RAD(rotation_object[_z]));

	trigo.sin[_x] = sin(DEG2RAD(rotation_object[_x]));
	trigo.sin[_y] = sin(DEG2RAD(rotation_object[_y]));
	trigo.sin[_z] = sin(DEG2RAD(rotation_object[_z]));



	trigo.end_coord[_x] = trigo.coord[_x] * ((trigo.cos[_y] * trigo.cos[_z])) - trigo.coord[_y] * ((trigo.cos[_y] * trigo.sin[_z])) - trigo.coord[_z] * (trigo.sin[_y]);
	trigo.end_coord[_y] = trigo.coord[_x] * ((trigo.cos[_x] * trigo.sin[_z]) - (trigo.sin[_x] * trigo.sin[_y] * trigo.cos[_z])) + trigo.coord[_y] * ((trigo.sin[_x] * trigo.sin[_y] * trigo.sin[_z]) + (trigo.cos[_x] * trigo.cos[_z])) - trigo.coord[_z] * (trigo.sin[_x] * trigo.cos[_y]);
	trigo.end_coord[_z] = trigo.coord[_x] * ((trigo.cos[_x] * trigo.sin[_y] * trigo.cos[_z]) + (trigo.sin[_x] * trigo.sin[_z])) + trigo.coord[_y] * ((trigo.sin[_x] * trigo.cos[_z]) - (trigo.cos[_x] * trigo.sin[_y] * trigo.sin[_z])) + trigo.coord[_z] * (trigo.cos[_x] * trigo.cos[_y]);

	trigo.end_coord[_x] = (trigo.end_coord[_x] * FOCALE) / (trigo.end_coord[_z] + PROFONDEUR);
	trigo.end_coord[_y] = (trigo.end_coord[_y] * FOCALE) / (trigo.end_coord[_z] + PROFONDEUR);

	offset_pixel = REPERE - (LENGTH * (int)trigo.end_coord[_y]) + (int)trigo.end_coord[_x];

	if ((trigo.end_coord[_x] <= (LENGTH / 2) - 1 && trigo.end_coord[_x] >= (-LENGTH / 2) + 1) &&
		(trigo.end_coord[_y] <= (WIDTH / 2) - 1 && trigo.end_coord[_y] >= -(WIDTH / 2) + 1))
		screen[offset_pixel] = color;
}

void        trace_circle(float rayon, float *repere)
{
	float   point[3], angle_circle;

	point[2] = 0;
	angle_circle = 0;
	while (angle_circle <= 360)
	{
		angle_circle += 0.1;
		/*		point[_x] = cos(DEG2RAD(angle_circle)) * rayon;
		point[_y] = sin(DEG2RAD(angle_circle)) * rayon;
		*/		put_pixel(point, WHITE, repere);
	}

	rayon = 200;
	point[_x] = -rayon;
	while (point[_x] <= rayon)
	{
		point[_y] = sqrt((rayon * rayon) - (point[_x] * point[_x]));
		put_pixel(point, WHITE, repere_object);
		put_pixel(point, WHITE, repere_object);
		point[_x] += 0.001;
	}

}

void        trace_droite2D(float lenght)
{
	float   point[3], a, b, c;

	a = b = c = 1;
	point[_x] = -lenght;
	point[_z] = 0;
	while (point[_x] <= lenght)
	{
		point[_y] = -((a * point[_x] + c) / b);

		put_pixel(point, WHITE, repere_object);
		point[_x] += 0.1;
	}
}

void        rotation_2D(float *object, int size, float yangle_add, float xangle_add, float zangle_add)
{
	float   rayon, xangle_point, yangle_point, zangle_point;
	float	point[3];
	int     indice = 0;

	while (indice != size)
	{
		point[_x] = object[indice];
		point[_y] = object[indice + 1];
		point[_z] = object[indice + 2];

		rayon = sqrt(point[_x] * point[_x] + point[_y] * point[_y] + point[_z] * point[_z]);
		xangle_point = acos(point[_x] / rayon);
		yangle_point = asin(point[_y] / rayon);
		zangle_point = asin(point[_z] / rayon);

		/*		point[_x] = rayon * cos(xangle_point + xangle_add);
		point[_y] = rayon * sin(yangle_point + yangle_add);
		point[_y] = rayon * sin(zangle_point + zangle_add);
		*/		if (zangle_add != 0)
		{
			/*			point[_x] = rayon * cos(xangle_point + zangle_add);
			point[_y] = rayon * sin(xangle_point + zangle_add);
			*/
		}
		put_pixel(point, WHITE, repere_object);
		put_pixel(point, WHITE, repere_object);

		indice += 3;
	}
}

void        make_voxel_weapon(float *cube, float size)
{
	float   x, z;
	float   cote_voxel_cube = size;
	int     indice;
	float   angle;

	x = cote_voxel_cube;
	indice = angle = 0;
	while (x > -cote_voxel_cube) //fill_cube_volume
	{
		z = cote_voxel_cube;
		while (z > -cote_voxel_cube) //fill_cube_line
		{
			angle++;
			/*			cube[indice + 0] = cos(DEG2RAD(angle)) * x * 8;
			cube[indice + 1] = sin(DEG2RAD(angle)) * x;
			*/			cube[indice + 2] = z;
			cube[indice + 3] = BLUE;
			indice += 4;
			z--;
		}
		x--;
	}

}

void        put_object(float *object, int size, float *repere)
{
	while (size--)
	{
		put_pixel(object, object[3], repere);
		object += 4;
	}
}

void        clear_screen(void)
{
	int     loop = 0;
	while (loop < LENGTH*WIDTH)
	{
		screen[loop++] = 0;
	}

}

void        reset_phi(void)
{
	if (rotation_object[_x] >= 360)
		rotation_object[_x] = 0;

	if (rotation_object[_y] >= 360)
		rotation_object[_y] = 0;

	if (rotation_object[_z] >= 360)
		rotation_object[_z] = 0;
}

void        scale_object(float *object, int size_object, float size_scale)
{
	while (size_object--)
	{
		*(object + _x) *= size_scale;    //x
		*(object + _y) *= size_scale;    //y
		*(object + _z) *= size_scale;    //z
		object += 4;
	}
}

void        make_voxel_cube(float *cube, float size)
{
	float   x, y, z;
	float   cote_voxel_cube = size;
	int     indice;

	x = cote_voxel_cube;
	indice = 0;
	while (x >= -cote_voxel_cube) //fill_cube_volume
	{
		y = cote_voxel_cube;
		while (y >= -cote_voxel_cube) //fill_cube_surface
		{
			z = cote_voxel_cube;
			while (z >= -cote_voxel_cube) //fill_cube_line
			{
				cube[indice + _x] = x * 1200; // distance between vertex
				cube[indice + _y] = y * 1200;
				cube[indice + _z] = z * 1200;
				cube[indice + 3] = BLUE;
				indice += 4;
				z--;
			}
			y--;
		}
		x--;
	}
}

void        make_voxel_map(float *cube, float size)
{
	float   x, z;
	float   cote_voxel_cube = size;
	int     indice;
	float   angle;

	x = cote_voxel_cube;
	indice = angle = 0;
	while (x > -cote_voxel_cube) //fill_cube_volume
	{
		z = cote_voxel_cube;
		while (z > -cote_voxel_cube) //fill_cube_line
		{
			angle += 5;
			cube[indice + _x] = x * 8;
			//			cube[indice + _y] = sin(DEG2RAD(angle)) * 20;
			cube[indice + _z] = z * 8;
			cube[indice + 3] = BLUE;
			indice += 4;
			z--;
		}
		angle = 0;
		x--;
	}
}

void        make_repere(float *repere)
{
	float   x, y, z;
	int     indice;

	x = -(LENGTH / 2);
	y = -(WIDTH / 2);
	z = -(DEPTH / 2);
	indice = 0;
	while (x < LENGTH / 2)
	{
		repere[indice + _x] = x++;
		repere[indice + _y] = 0;
		repere[indice + _z] = 0;
		repere[indice + 3] = BLUE;
		indice += 4;
	}

	while (y < WIDTH / 2)
	{
		repere[indice + _x] = 0;
		repere[indice + _y] = y++;
		repere[indice + _z] = 0;
		repere[indice + 3] = GREEN;
		indice += 4;
	}

	while (z < DEPTH / 2)
	{
		repere[indice + _x] = 0;
		repere[indice + _y] = 0;
		repere[indice + _z] = z++;
		repere[indice + 3] = RED;
		indice += 4;
	}
}

void	upload_screen()
{
	SetBitmapBits(texture, LENGTH*WIDTH * 4, screen);
	SelectObject(device_context_texture, texture);
}

LRESULT		WndProc(HWND windows_handle, UINT event, WPARAM wParam, LPARAM lParam)
{
	switch (event)
	{
		case WM_PAINT:

		break;

		case WM_DESTROY:
			PostQuitMessage(0);
		break;

		default:
			return DefWindowProc(windows_handle, event, wParam, lParam);
	}

	return 0xdeadbeef;
}

void	init_video(void)
{
		windows_class.cbClsExtra = 0;
		windows_class.cbWndExtra = 0;
		windows_class.hbrBackground = 0;
		windows_class.hCursor = 0;
		windows_class.hIcon = 0;
		windows_class.hInstance = instance;
		windows_class.lpfnWndProc = WndProc;
		windows_class.lpszClassName = "Classe 1";
		windows_class.lpszMenuName = NULL;
		windows_class.style = CS_HREDRAW | CS_VREDRAW;
	RegisterClass(&windows_class);

	windows_handle = CreateWindow(	"Classe 1",
									"Notre premire fentre",
									WS_OVERLAPPEDWINDOW | WS_VISIBLE,
									CW_USEDEFAULT, CW_USEDEFAULT, LENGTH, WIDTH,
									NULL,
									NULL,
									instance,
									NULL);

	device_context_screen = GetDC(windows_handle);
	texture = CreateCompatibleBitmap(device_context_screen, LENGTH, WIDTH);
	device_context_texture = CreateCompatibleDC(device_context_screen);
}

int					main(HINSTANCE _instance, HINSTANCE hPrevInstance, LPSTR cmd_line, int cmd_show)
{
	int				offset = 0;
	int				count = 0;
	int				offset_pixel = 0;
	int             FPS_COUNTER_DATA[4] = { 0 };    // 0: fps , 1: compteur_boucle , 2: last_time , 3: current_time
	int             quit = 1;
	static float    voxel_rhino[13998 * 4] = {
												#include "data/Rhino.obj"
											 };

	static float    voxel_city[87840 * 4] = {
												#include "data/serpentine city.obj"
											};

	static float    voxel_cube[100 * 100 * 100 * 4];
	static float    voxel_map[300 * 300 * 4];
	static float    repere[(LENGTH + WIDTH + 0) * 4];
	static float    cube[8 * 4] = {	/// Fae avant du cube
									///   X	   Y       Z 	 color
									-100.0, -100.0, 100.0, WHITE  /// Le point en haut  gauche de la fae avant du cube
									, -100.0, 100.0, 100.0, WHITE  /// Le point en bas  gauche de la fae avant du cube
									, 100.0, -100.0, 100.0, WHITE  /// Le point en bas  droite de la fae avant du cube
									, 100.0, 100.0, 100.0, WHITE  /// Le point en haut  droite de la fae avant du cube
									/// Fae arriere du cube
									, -100.0, -100.0, -100.0, WHITE  /// Le point en haut  gauche de la fae arriere du cube
									, -100.0, 100.0, -100.0, WHITE  /// Le point en bas  gauche de la fae arriere du cube
									, 100.0, -100.0, -100.0, WHITE  /// Le point en haut  droite de la fae arriere du cube
									, 100.0, 100.0, -100.0, WHITE  /// Le point en bas  droite de la fae arriere du cube
								  };
	
	make_voxel_cube(voxel_cube, 50);
	make_voxel_map(voxel_map, 150);
	make_repere(repere);
	scale_object(voxel_rhino, 13997, 450);
	scale_object(voxel_city, 87840, 5);

	rotation_object[_x] = -20;
	repere_object2[_y] = 100;

	instance = _instance;
	init_video();

	//while (GetMessage(&event, NULL, 0, 0))
	while (1)
	{
		rotation_object[_y] += 1;
		put_object(voxel_cube, 100 * 100 * 100, repere_object);
	 	
	/*	put_object(voxel_rhino, 13998, repere_object);
		put_object(voxel_city, 87840, repere_object);
	 
		put_object(repere, LENGTH + WIDTH, repere_object);
		trace_circle(100, repere_object);
		trace_circle(100, repere_object2);
      */

		calculate_fps:
		{
			FPS_COUNTER_DATA[3] = clock();
			FPS_COUNTER_DATA[1]++;
			if (FPS_COUNTER_DATA[3] - FPS_COUNTER_DATA[2] >= 1000)
			{
					FPS_COUNTER_DATA[0] = FPS_COUNTER_DATA[1];
					FPS_COUNTER_DATA[1] = 0;
					FPS_COUNTER_DATA[2] = clock();
			}
			printf("FPS = %d\n", FPS_COUNTER_DATA[0]);

		}

		BeginPaint(windows_handle, &paint_struct);
			upload_screen();
			BitBlt(device_context_screen, 0, 0, LENGTH, WIDTH, device_context_texture, 0, 0, SRCCOPY);
		EndPaint(windows_handle, &paint_struct);

		//TranslateMessage(&event);
		//DispatchMessage(&event);

		clear_screen();
		reset_phi();
	}

	DeleteObject(texture);
	DeleteDC(device_context_texture);

	return 0xdeadbeef;
}