program feast
    implicit none
    EXTERNAL DFEAST_SCSRGV
    
    INTEGER, parameter :: num_nonzeroa=120, num_nonzerob=120, n=36, n1=37, m0size=10
    
    INTEGER :: m, loop, info, m0, i
    REAL*8 :: espout=0.0    
    REAL*8 ::   emin = 0.0, emax = 1194.2221
    INTEGER :: fpm(128)    
    INTEGER :: ia(n1)
    INTEGER :: ja(num_nonzeroa)    
    REAL*8 :: a(num_nonzeroa)
    INTEGER :: ib(n1)
    INTEGER :: jb(num_nonzerob)    
    REAL*8 :: b(num_nonzerob)
    REAL*8 :: x(n, m0size)
    REAL*8 :: e(m0size)
    REAL*8 :: res(m0size)
 
    fpm(2) = 8
    fpm(3) = 12
    fpm(4) = 20
    fpm(7) = 5
    
    m0 = m0size

    OPEN (UNIT = 1, FILE='EIGENINPUT.DAT', FORM = 'UNFORMATTED', STATUS='UNKNOWN')      
    READ(1) ia,ja,ib,jb,a,b
    CLOSE(1)        

    Call DFEAST_SCSRGV('U', n, a, ia, ja, b, ib, jb, fpm, espout, loop, emin, emax, m0, e, x, m, res, info)
              
    write(*,100) "info =  ", info
    if (info == 0) then
        write(*,101) "Numner of Eigenvalues found for range emin ", emin, " to emax ", emax, " is ", m, " with m0 = ", m0size
        do i=1,m
            write(*,102) "Eigenvalue ", i, " = ", e(i)
        end do
    end if
    
    100 format (A, I2)        
    101 format (A, F8.2, A, F8.2, A, I2, A, I2)
    102 format (A, I2, A, F8.2)    
 
end program feast