// OpenCLTest.cpp : ̨Ӧóڵ㡣
//

#include "stdafx.h"
#include <fstream>
#include <iostream>
#include <cstring>
#include <conio.h>
#define __CL_ENABLE_EXCEPTIONS
#include <CL/cl.hpp>

const char KERNEL_FILE[] = "../../OpenCLTest/OpenCL_kernel2.cl";
const size_t NUM_PARALLEL = 1024;

const char* get_file_content(const char* filepath, size_t& size)
{
	std::ifstream ifs(filepath, std::ifstream::binary | std::ifstream::in);
	if (!ifs)
		return NULL;

	ifs.seekg(0, std::ifstream::end);
	size = ifs.tellg();
	ifs.seekg(0, std::ifstream::beg);

	char* contents = (char*) ::malloc(size + 1);
	ifs.read(contents, size);
	contents[size] = '\0';
	ifs.close();

	return contents;
}

void runOpenCL()
{
	size_t length;
	const char* contents = get_file_content(KERNEL_FILE, length);
	cl::Program::Sources source(1, std::make_pair(contents, length));

	std::vector<cl::Platform> platforms;
	cl::Platform::get(&platforms);
	for (auto platform : platforms) {
		std::vector<cl::Device> devices;
		try {
			platform.getDevices(CL_DEVICE_TYPE_GPU, &devices);
		}
		catch (cl::Error&) {
			continue;
		}
		//			if (platform.getInfo<CL_PLATFORM_NAME>().substr(0, 5) == "Intel")
		//				continue; // Bypass Intel HD4600 GPU for suspicious bug
		for (auto device : devices) {
			auto sizesItem = device.getInfo<CL_DEVICE_MAX_WORK_ITEM_SIZES>();

			cl::Context context(device);
			cl::Program program(context, source);
			try {
				program.build();
				typedef cl::make_kernel<cl::Buffer&, cl::Buffer&> KernelType;
				KernelType kernel(program, "prepareNodes");

				cl::CommandQueue queue(context, device);
				size_t work_size = (NUM_PARALLEL + sizesItem[0] - 1) / sizesItem[0] * sizesItem[0];
				cl::NDRange globalNDR(work_size);
				cl::NDRange localNDR(sizesItem[0]);

				char source[100] = "33";
				cl::Buffer bufferSrc(context, CL_MEM_READ_WRITE | CL_MEM_COPY_HOST_PTR, sizeof(source), source);
				char work_buffer[491520];
				cl::Buffer bufferWork(context, CL_MEM_READ_WRITE | CL_MEM_COPY_HOST_PTR, sizeof(work_buffer), work_buffer);

				cl::EnqueueArgs arg(queue, cl::NullRange, globalNDR, localNDR);
				kernel(arg, bufferSrc, bufferWork);
				char* buffer = (char*)queue.enqueueMapBuffer(bufferWork, CL_TRUE, CL_MAP_READ, 0, sizeof(work_buffer));
				queue.enqueueUnmapMemObject(bufferWork, buffer);
			}
			catch (cl::Error& e) {
				std::cerr << "Error in " << e.what() << " (" << e.err() << ")" << std::endl;
				std::cerr << program.getBuildInfo<CL_PROGRAM_BUILD_LOG>(device) << std::endl;
			}
		}
		std::cout << std::endl;
	}

	::free((void*)contents);
}

int _tmain(int argc, _TCHAR* argv[])
{
	runOpenCL();
	std::cout << "Press space key to run repeatly, or Q(q) to exit ..." << std::endl;
	char c;
	while (true) {
		do {
			c = _getch();
		} while (c != ' ' && c != 'q' && c != 'Q');
		if (c == 'q' || c == 'Q')
			break;
		runOpenCL();
	}
	return 0;
}

