! test code
module test_abstract_config
  use vast_abstract_config, only: AbstractConfigNode_type
  use vast_env, only: label_len
  use vast_error, only: FunctionalError, ArgumentError
  implicit none
  public

  ! don't spoil public module data (ifort is sensible!)
  private :: AbstractConfigNode_type, label_len
  private :: FunctionalError, ArgumentError
  private :: node

  type(AbstractConfigNode_type) :: node

contains

  !@before
  subroutine setUp
    use pfunit_mod
    use tixi, only: SUCCESS, tixiCreateDocument

#line 23 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiCreateDocument('root', node%tixiHandle), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 23) )
  if (anyExceptions()) return
#line 24 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    node%xml_path = '/root'

  end subroutine

  !@after
  subroutine tearDown
    use pfunit_mod
    use tixi, only: SUCCESS, tixiCloseDocument

#line 33 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiCloseDocument(node%tixiHandle), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 33) )
  if (anyExceptions()) return
#line 34 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    node%tixiHandle = -1
    node%xml_path = ''

  end subroutine


  !@test
  subroutine test_getName
    use pfunit_mod
    character(len=label_len) :: name
    integer :: ierr

    name = node%getName(ierr)
#line 47 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 47) )
  if (anyExceptions()) return
#line 48 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 48 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual('root', trim(name), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 48) )
  if (anyExceptions()) return
#line 49 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    node%xml_path = ''
    name = node%getName(ierr)
#line 52 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(FunctionalError, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 52) )
  if (anyExceptions()) return
#line 53 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    node%xml_path = '/hello/world'
    name = node%getName(ierr)
#line 56 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 56) )
  if (anyExceptions()) return
#line 57 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 57 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual('world', trim(name), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 57) )
  if (anyExceptions()) return
#line 58 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    node%xml_path = '/this/world[12]/is[0]/strange[99]'
    name = node%getName(ierr)
#line 61 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 61) )
  if (anyExceptions()) return
#line 62 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 62 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual('strange', trim(name), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 62) )
  if (anyExceptions()) return
#line 63 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getNumberOfChildren
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddTextElement
    integer :: ierr, nElems

    nElems = node%getNumberOfChildren(ierr)
#line 74 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 74) )
  if (anyExceptions()) return
#line 75 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 75 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, nElems, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 75) )
  if (anyExceptions()) return
#line 76 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

#line 77 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'test', 'hello'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 77) )
  if (anyExceptions()) return
#line 78 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    nElems = node%getNumberOfChildren(ierr)
#line 79 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 79) )
  if (anyExceptions()) return
#line 80 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 80 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(1, nElems, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 80) )
  if (anyExceptions()) return
#line 81 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

#line 82 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'test', 'world'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 82) )
  if (anyExceptions()) return
#line 83 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 83 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'another_test', 'whoaa'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 83) )
  if (anyExceptions()) return
#line 84 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    nElems = node%getNumberOfChildren(ierr)
#line 85 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 85) )
  if (anyExceptions()) return
#line 86 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 86 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(3, nElems, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 86) )
  if (anyExceptions()) return
#line 87 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getChildNode
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddTextElement
    integer :: ierr
    type(AbstractConfigNode_type) :: childNode

    ! give me an error when there is no child
    childNode = node%getChildNode(1, ierr)
#line 100 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(ArgumentError, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 100) )
  if (anyExceptions()) return
#line 101 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    ! populate node
#line 103 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'test', 'hello'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 103) )
  if (anyExceptions()) return
#line 104 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 104 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'another_test', 'world'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 104) )
  if (anyExceptions()) return
#line 105 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 105 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'nonunique_name', 'this'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 105) )
  if (anyExceptions()) return
#line 106 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 106 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'unique_name', 'some text'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 106) )
  if (anyExceptions()) return
#line 107 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 107 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'nonunique_name', 'node'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 107) )
  if (anyExceptions()) return
#line 108 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 108 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'nonunique_name', 'name'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 108) )
  if (anyExceptions()) return
#line 109 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 109 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'nonunique_name', 'occurs'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 109) )
  if (anyExceptions()) return
#line 110 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 110 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'nonunique_name', 'multiple'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 110) )
  if (anyExceptions()) return
#line 111 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 111 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'nonunique_name', 'times'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 111) )
  if (anyExceptions()) return
#line 112 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 112 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'nonunique_name', '...'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 112) )
  if (anyExceptions()) return
#line 113 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 113 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'nonunique_name', '...'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 113) )
  if (anyExceptions()) return
#line 114 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 114 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'nonunique_name', '...'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 114) )
  if (anyExceptions()) return
#line 115 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 115 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'nonunique_name', '...'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 115) )
  if (anyExceptions()) return
#line 116 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 116 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'nonunique_name', '...'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 116) )
  if (anyExceptions()) return
#line 117 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    childNode = node%getChildNode(1, ierr)
#line 119 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 119) )
  if (anyExceptions()) return
#line 120 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 120 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(childNode%tixiHandle, node%tixiHandle, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 120) )
  if (anyExceptions()) return
#line 121 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 121 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(trim(node%xml_path) // '/test', trim(childNode%xml_path), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 121) )
  if (anyExceptions()) return
#line 122 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    childNode = node%getChildNode(4, ierr)
#line 124 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 124) )
  if (anyExceptions()) return
#line 125 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 125 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(childNode%tixiHandle, node%tixiHandle, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 125) )
  if (anyExceptions()) return
#line 126 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 126 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(trim(node%xml_path) // '/unique_name', trim(childNode%xml_path), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 126) )
  if (anyExceptions()) return
#line 127 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    childNode = node%getChildNode(5, ierr)
#line 129 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 129) )
  if (anyExceptions()) return
#line 130 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 130 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(childNode%tixiHandle, node%tixiHandle, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 130) )
  if (anyExceptions()) return
#line 131 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 131 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(trim(node%xml_path) // '/nonunique_name[2]', trim(childNode%xml_path), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 131) )
  if (anyExceptions()) return
#line 132 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    childNode = node%getChildNode(3, ierr)
#line 134 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 134) )
  if (anyExceptions()) return
#line 135 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 135 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(childNode%tixiHandle, node%tixiHandle, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 135) )
  if (anyExceptions()) return
#line 136 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 136 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(trim(node%xml_path) // '/nonunique_name[1]', trim(childNode%xml_path), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 136) )
  if (anyExceptions()) return
#line 137 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    childNode = node%getChildNode(14, ierr)
#line 139 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 139) )
  if (anyExceptions()) return
#line 140 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 140 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(childNode%tixiHandle, node%tixiHandle, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 140) )
  if (anyExceptions()) return
#line 141 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 141 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(trim(node%xml_path) // '/nonunique_name[11]', trim(childNode%xml_path), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 141) )
  if (anyExceptions()) return
#line 142 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    childNode = node%getChildNode(0, ierr)
#line 144 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(ArgumentError, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 144) )
  if (anyExceptions()) return
#line 145 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    childNode = node%getChildNode(15, ierr)
#line 147 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(ArgumentError, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 147) )
  if (anyExceptions()) return
#line 148 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getElementValue_real
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddDoubleElement
    real :: x
    integer :: ierr

#line 159 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddDoubleElement(node%tixiHandle, trim(node%xml_path), 'test', 7.99, '%8.4g'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 159) )
  if (anyExceptions()) return
#line 160 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    x = 0
    call node%getElementValue('test', x, ierr)
#line 162 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 162) )
  if (anyExceptions()) return
#line 163 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 163 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(7.99, x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 163) )
  if (anyExceptions()) return
#line 164 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getElementValue_realArray
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddFloatVector
    real, allocatable :: x(:)
    integer :: ierr

#line 175 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddFloatVector(node%tixiHandle, trim(node%xml_path), 'test', (/1.9,2.7,3.0/), 3, '%8.4g'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 175) )
  if (anyExceptions()) return
#line 176 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    call node%getElementValue('test', x, ierr)
#line 177 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 177) )
  if (anyExceptions()) return
#line 178 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 178 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertTrue( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 178) )
  if (anyExceptions()) return
#line 179 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 179 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual((/1.9,2.7,3.0/), x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 179) )
  if (anyExceptions()) return
#line 180 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getElementValue_integer
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddIntegerElement
    integer :: x
    integer :: ierr

#line 191 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddIntegerElement(node%tixiHandle, trim(node%xml_path), 'test', 9, '%d'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 191) )
  if (anyExceptions()) return
#line 192 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    x = 0
    call node%getElementValue('test', x, ierr)
#line 194 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 194) )
  if (anyExceptions()) return
#line 195 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 195 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(9, x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 195) )
  if (anyExceptions()) return
#line 196 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getElementValue_node
    use pfunit_mod
    use tixi, only: SUCCESS, tixiCreateElement
    type(AbstractConfigNode_type) :: subNode
    integer :: ierr

#line 207 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiCreateElement(node%tixiHandle, trim(node%xml_path), 'test'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 207) )
  if (anyExceptions()) return
#line 208 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getElementValue('test', subNode, ierr)
#line 210 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 210) )
  if (anyExceptions()) return
#line 211 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 211 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(node%tixiHandle, subNode%tixiHandle, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 211) )
  if (anyExceptions()) return
#line 212 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 212 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual('/root/test', trim(subNode%xml_path), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 212) )
  if (anyExceptions()) return
#line 213 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getElementValue_logical
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddBooleanElement
    logical :: x
    integer :: ierr

#line 224 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddBooleanElement(node%tixiHandle, trim(node%xml_path), 'test', 1), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 224) )
  if (anyExceptions()) return
#line 225 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    x = .false.
    call node%getElementValue('test', x, ierr)
#line 227 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 227) )
  if (anyExceptions()) return
#line 228 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 228 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(.true., x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 228) )
  if (anyExceptions()) return
#line 229 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getElementValue_string
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddTextElement
    character(len=label_len) :: x
    integer :: ierr

#line 240 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'test', 'myText'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 240) )
  if (anyExceptions()) return
#line 241 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getElementValue('test', x, ierr)
#line 243 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 243) )
  if (anyExceptions()) return
#line 244 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 244 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual('myText', trim(x), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 244) )
  if (anyExceptions()) return
#line 245 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getAttributeValue_real
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddDoubleAttribute
    real :: x
    integer :: ierr

#line 256 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddDoubleAttribute(node%tixiHandle, trim(node%xml_path), 'test', 7.99, '%8.4g'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 256) )
  if (anyExceptions()) return
#line 257 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    x = 0
    call node%getAttributeValue('test', x, ierr)
#line 259 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 259) )
  if (anyExceptions()) return
#line 260 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 260 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(7.99, x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 260) )
  if (anyExceptions()) return
#line 261 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getAttributeValue_integer
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddIntegerAttribute
    integer :: x
    integer :: ierr

#line 272 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddIntegerAttribute(node%tixiHandle, trim(node%xml_path), 'test', 9, '%d'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 272) )
  if (anyExceptions()) return
#line 273 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    x = 0
    call node%getAttributeValue('test', x, ierr)
#line 275 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 275) )
  if (anyExceptions()) return
#line 276 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 276 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(9, x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 276) )
  if (anyExceptions()) return
#line 277 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getAttributeValue_logical
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddIntegerAttribute
    logical :: x
    integer :: ierr

#line 288 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddIntegerAttribute(node%tixiHandle, trim(node%xml_path), 'test', 1, '%d'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 288) )
  if (anyExceptions()) return
#line 289 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    x = .false.
    call node%getAttributeValue('test', x, ierr)
#line 291 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 291) )
  if (anyExceptions()) return
#line 292 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 292 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(.true., x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 292) )
  if (anyExceptions()) return
#line 293 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getAttributeValue_string
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddTextAttribute
    character(len=label_len) :: x
    integer :: ierr

#line 304 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextAttribute(node%tixiHandle, trim(node%xml_path), 'test', 'myText'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 304) )
  if (anyExceptions()) return
#line 305 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getAttributeValue('test', x, ierr)
#line 307 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 307) )
  if (anyExceptions()) return
#line 308 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 308 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual('myText', trim(x), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 308) )
  if (anyExceptions()) return
#line 309 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine




  !@test
  subroutine test_getOptionalElementValue_real
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddDoubleElement
    real, allocatable :: x
    integer :: ierr

#line 322 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddDoubleElement(node%tixiHandle, trim(node%xml_path), 'test', 7.99, '%8.4g'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 322) )
  if (anyExceptions()) return
#line 323 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    x = 0
    call node%getOptionalElementValue('test', x, ierr)
#line 325 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 325) )
  if (anyExceptions()) return
#line 326 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 326 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertTrue( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 326) )
  if (anyExceptions()) return
#line 327 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 327 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(7.99, x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 327) )
  if (anyExceptions()) return
#line 328 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalElementValue('nonexisting', x, ierr)
#line 330 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 330) )
  if (anyExceptions()) return
#line 331 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 331 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertFalse( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 331) )
  if (anyExceptions()) return
#line 332 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getOptionalElementValue_realArray
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddFloatVector
    real, allocatable :: x(:)
    integer :: ierr

#line 343 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddFloatVector(node%tixiHandle, trim(node%xml_path), 'test', (/1.9,2.7,3.0/), 3, '%8.4g'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 343) )
  if (anyExceptions()) return
#line 344 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    call node%getOptionalElementValue('test', x, ierr)
#line 345 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 345) )
  if (anyExceptions()) return
#line 346 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 346 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertTrue( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 346) )
  if (anyExceptions()) return
#line 347 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 347 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual((/1.9,2.7,3.0/), x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 347) )
  if (anyExceptions()) return
#line 348 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalElementValue('nonexisting', x, ierr)
#line 350 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 350) )
  if (anyExceptions()) return
#line 351 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 351 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertFalse( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 351) )
  if (anyExceptions()) return
#line 352 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getOptionalElementValue_integer
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddIntegerElement
    integer, allocatable :: x
    integer :: ierr

#line 363 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddIntegerElement(node%tixiHandle, trim(node%xml_path), 'test', 9, '%d'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 363) )
  if (anyExceptions()) return
#line 364 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    x = 0
    call node%getOptionalElementValue('test', x, ierr)
#line 366 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 366) )
  if (anyExceptions()) return
#line 367 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 367 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertTrue( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 367) )
  if (anyExceptions()) return
#line 368 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 368 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(9, x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 368) )
  if (anyExceptions()) return
#line 369 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalElementValue('nonexisting', x, ierr)
#line 371 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 371) )
  if (anyExceptions()) return
#line 372 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 372 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertFalse( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 372) )
  if (anyExceptions()) return
#line 373 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getOptionalElementValue_node
    use pfunit_mod
    use tixi, only: SUCCESS, tixiCreateElement
    type(AbstractConfigNode_type), allocatable :: subNode
    integer :: ierr

#line 384 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiCreateElement(node%tixiHandle, trim(node%xml_path), 'test'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 384) )
  if (anyExceptions()) return
#line 385 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalElementValue('test', subNode, ierr)
#line 387 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 387) )
  if (anyExceptions()) return
#line 388 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 388 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertTrue( allocated(subNode) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 388) )
  if (anyExceptions()) return
#line 389 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 389 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(node%tixiHandle, subNode%tixiHandle, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 389) )
  if (anyExceptions()) return
#line 390 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 390 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual('/root/test', trim(subNode%xml_path), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 390) )
  if (anyExceptions()) return
#line 391 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalElementValue('nonexisting', subNode, ierr)
#line 393 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 393) )
  if (anyExceptions()) return
#line 394 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 394 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertFalse( allocated(subNode) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 394) )
  if (anyExceptions()) return
#line 395 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getOptionalElementValue_logical
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddBooleanElement
    logical, allocatable :: x
    integer :: ierr

#line 406 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddBooleanElement(node%tixiHandle, trim(node%xml_path), 'test', 1), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 406) )
  if (anyExceptions()) return
#line 407 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    x = .false.
    call node%getOptionalElementValue('test', x, ierr)
#line 409 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 409) )
  if (anyExceptions()) return
#line 410 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 410 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertTrue( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 410) )
  if (anyExceptions()) return
#line 411 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 411 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(.true., x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 411) )
  if (anyExceptions()) return
#line 412 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalElementValue('nonexisting', x, ierr)
#line 414 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 414) )
  if (anyExceptions()) return
#line 415 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 415 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertFalse( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 415) )
  if (anyExceptions()) return
#line 416 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getOptionalElementValue_string
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddTextElement
    character(len=label_len), allocatable :: x
    integer :: ierr

#line 427 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextElement(node%tixiHandle, trim(node%xml_path), 'test', 'myText'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 427) )
  if (anyExceptions()) return
#line 428 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalElementValue('test', x, ierr)
#line 430 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 430) )
  if (anyExceptions()) return
#line 431 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 431 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertTrue( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 431) )
  if (anyExceptions()) return
#line 432 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 432 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual('myText', trim(x), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 432) )
  if (anyExceptions()) return
#line 433 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalElementValue('nonexisting', x, ierr)
#line 435 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 435) )
  if (anyExceptions()) return
#line 436 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 436 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertFalse( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 436) )
  if (anyExceptions()) return
#line 437 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getOptionalAttributeValue_real
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddDoubleAttribute
    real, allocatable :: x
    integer :: ierr

#line 448 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddDoubleAttribute(node%tixiHandle, trim(node%xml_path), 'test', 7.99, '%8.4g'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 448) )
  if (anyExceptions()) return
#line 449 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    x = 0
    call node%getOptionalAttributeValue('test', x, ierr)
#line 451 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 451) )
  if (anyExceptions()) return
#line 452 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 452 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertTrue( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 452) )
  if (anyExceptions()) return
#line 453 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 453 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(7.99, x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 453) )
  if (anyExceptions()) return
#line 454 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalElementValue('nonexisting', x, ierr)
#line 456 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 456) )
  if (anyExceptions()) return
#line 457 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 457 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertFalse( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 457) )
  if (anyExceptions()) return
#line 458 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getOptionalAttributeValue_integer
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddIntegerAttribute
    integer, allocatable :: x
    integer :: ierr

#line 469 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddIntegerAttribute(node%tixiHandle, trim(node%xml_path), 'test', 9, '%d'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 469) )
  if (anyExceptions()) return
#line 470 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    x = 0
    call node%getOptionalAttributeValue('test', x, ierr)
#line 472 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 472) )
  if (anyExceptions()) return
#line 473 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 473 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertTrue( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 473) )
  if (anyExceptions()) return
#line 474 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 474 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(9, x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 474) )
  if (anyExceptions()) return
#line 475 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalElementValue('nonexisting', x, ierr)
#line 477 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 477) )
  if (anyExceptions()) return
#line 478 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 478 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertFalse( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 478) )
  if (anyExceptions()) return
#line 479 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getOptionalAttributeValue_logical
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddIntegerAttribute
    logical, allocatable :: x
    integer :: ierr

#line 490 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddIntegerAttribute(node%tixiHandle, trim(node%xml_path), 'test', 1, '%d'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 490) )
  if (anyExceptions()) return
#line 491 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
    x = .false.
    call node%getOptionalAttributeValue('test', x, ierr)
#line 493 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 493) )
  if (anyExceptions()) return
#line 494 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 494 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertTrue( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 494) )
  if (anyExceptions()) return
#line 495 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 495 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(.true., x, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 495) )
  if (anyExceptions()) return
#line 496 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalElementValue('nonexisting', x, ierr)
#line 498 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 498) )
  if (anyExceptions()) return
#line 499 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 499 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertFalse( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 499) )
  if (anyExceptions()) return
#line 500 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


  !@test
  subroutine test_getOptionalAttributeValue_string
    use pfunit_mod
    use tixi, only: SUCCESS, tixiAddTextAttribute
    character(len=label_len), allocatable :: x
    integer :: ierr

#line 511 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(SUCCESS, tixiAddTextAttribute(node%tixiHandle, trim(node%xml_path), 'test', 'myText'), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 511) )
  if (anyExceptions()) return
#line 512 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalAttributeValue('test', x, ierr)
#line 514 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 514) )
  if (anyExceptions()) return
#line 515 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 515 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertTrue( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 515) )
  if (anyExceptions()) return
#line 516 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 516 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual('myText', trim(x), &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 516) )
  if (anyExceptions()) return
#line 517 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

    call node%getOptionalElementValue('nonexisting', x, ierr)
#line 519 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertEqual(0, ierr, &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 519) )
  if (anyExceptions()) return
#line 520 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
#line 520 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"
  call assertFalse( allocated(x) , &
 & location=SourceLocation( &
 & 'test_abstract_config.pfunit', &
 & 520) )
  if (anyExceptions()) return
#line 521 "/home_local/zoel_ml/VAST_playground/test/unit/abstract_core/test_abstract_config.pfunit"

  end subroutine


end module test_abstract_config

module Wraptest_abstract_config
   use pFUnit_mod
   use test_abstract_config
   implicit none
   private

contains


end module Wraptest_abstract_config

function test_abstract_config_suite() result(suite)
   use pFUnit_mod
   use test_abstract_config
   use Wraptest_abstract_config
   type (TestSuite) :: suite

   suite = newTestSuite('test_abstract_config_suite')

   call suite%addTest(newTestMethod('test_getName', test_getName, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getNumberOfChildren', test_getNumberOfChildren, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getChildNode', test_getChildNode, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getElementValue_real', test_getElementValue_real, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getElementValue_realArray', test_getElementValue_realArray, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getElementValue_integer', test_getElementValue_integer, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getElementValue_node', test_getElementValue_node, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getElementValue_logical', test_getElementValue_logical, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getElementValue_string', test_getElementValue_string, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getAttributeValue_real', test_getAttributeValue_real, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getAttributeValue_integer', test_getAttributeValue_integer, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getAttributeValue_logical', test_getAttributeValue_logical, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getAttributeValue_string', test_getAttributeValue_string, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getOptionalElementValue_real', test_getOptionalElementValue_real, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getOptionalElementValue_realArray', test_getOptionalElementValue_realArray, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getOptionalElementValue_integer', test_getOptionalElementValue_integer, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getOptionalElementValue_node', test_getOptionalElementValue_node, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getOptionalElementValue_logical', test_getOptionalElementValue_logical, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getOptionalElementValue_string', test_getOptionalElementValue_string, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getOptionalAttributeValue_real', test_getOptionalAttributeValue_real, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getOptionalAttributeValue_integer', test_getOptionalAttributeValue_integer, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getOptionalAttributeValue_logical', test_getOptionalAttributeValue_logical, setUp, tearDown))

   call suite%addTest(newTestMethod('test_getOptionalAttributeValue_string', test_getOptionalAttributeValue_string, setUp, tearDown))


end function test_abstract_config_suite

