      subroutine response(nsect,nout,ninp,nn,wt,ftsec,b,aa,bb,info)
c
c  birrp
c
c  computes l2 response function
c
c  input variables
c    nsect-number of sections
c    nout-number of output variables
c    ninp-number of input variables
c    nn-index of output variable
c    wt-weight vector of length nsect
c    ftsec-array containing fourier transform estimates
c  output variables
c    b-double complex vector of transfer functions
c    aa-double complex array containing input spectral matrix
c    bb-double complex vector containing input/output cross spectra
c    info-error flag, 0 for normal return and 1 for singular matrix
c
      include 'parameters.h'
      double complex b,aa,bb
      complex ftsec
      double precision rcond
      dimension wt(*),ftsec(nsectm,*)
      dimension b(*),aa(nrefm,*),bb(*)
      double complex a,z
      dimension a(nrefm,nrefm),z(nrefm),ipvt(nrefm)
      info=0
      do 10 i=1,ninp
        b(i)=0.
        do 10 j=1,ninp
   10     a(i,j)=0.
      do 25 k=1,nsect
        if(wt(k).eq.0.)goto 25
        do 20 i=1,ninp
          b(i)=b(i)+wt(k)**2*conjg(ftsec(k,nout+ninp+i))*
     $         ftsec(k,nn)
          do 20 j=1,ninp
   20       a(i,j)=a(i,j)+wt(k)**2*conjg(ftsec(k,nout+ninp+i))*
     $             ftsec(k,nout+j)
   25   continue
      do 30 i=1,ninp
        bb(i)=b(i)
        do 30 j=1,ninp
   30     aa(i,j)=a(i,j)
      call zgeco(a,nrefm,ninp,ipvt,rcond,z)
      if(1.d0+rcond.eq.1.d0)info=1
      job=0
      call zgesl(a,nrefm,ninp,ipvt,b,job)
      return
      end
      subroutine transfer(nsect,ninp,nref,nn,wt,ftsec,b,aa,bb,info)
c
c  birrp
c
c  computes l2 magnetic transfer function
c
c  input variables
c    nsect-number of sections
c    ninp-number of input (local magnetic field) variables
c    nref-number of reference magnetic field variables
c    nn-index of input variable
c    wt-weight vector of length nsect
c    ftsec-array containing fourier transform estimates
c  output variables
c    b-double complex vector of transfer functions
c    aa-double complex array containing input spectral matrix
c    bb-double complex vector containing input/output cross spectra
c    info-error flag, 0 for normal return and 1 for singular matrix
c
      include 'parameters.h'
      double complex b,aa,bb
      complex ftsec
      double precision rcond
      dimension wt(*),ftsec(nsectm,*)
      dimension b(*),aa(nrefm,*),bb(*)
      double complex a,z
      dimension a(nrefm,nrefm),z(nrefm),ipvt(nrefm)
      info=0
      do 10 i=1,nref
        b(i)=0.
        do 10 j=1,nref
   10     a(i,j)=0.
      do 25 k=1,nsect
        if(wt(k).eq.0.)goto 25
        do 20 i=1,nref
          b(i)=b(i)+wt(k)**2*conjg(ftsec(k,ninp+i))*
     $         ftsec(k,nn)
          do 20 j=1,nref
   20       a(i,j)=a(i,j)+wt(k)**2*conjg(ftsec(k,ninp+i))*
     $             ftsec(k,ninp+j)
   25   continue
      do 30 i=1,nref
        bb(i)=b(i)
        do 30 j=1,nref
   30     aa(i,j)=a(i,j)
      call zgeco(a,nrefm,nref,ipvt,rcond,z)
      if(1.d0+rcond.eq.1.d0)info=1
      job=0
      call zgesl(a,nrefm,nref,ipvt,b,job)
      return
      end
