/** @file
  TODO: Brief Description of UEFI Driver driver2
  
  TODO: Detailed Description of UEFI Driver driver2

  TODO: Copyright for UEFI Driver driver2
  
  TODO: License for UEFI Driver driver2

**/

#ifndef __EFI_DRIVER2_H__
#define __EFI_DRIVER2_H__

#include <Uefi.h>

//
// Libraries
//
#include <Library/UefiBootServicesTableLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/BaseLib.h>
#include <Library/UefiLib.h>
#include <Library/DevicePathLib.h>
#include <Library/DebugLib.h>

//
// UEFI Driver Model Protocols
//
#include <Protocol/DriverBinding.h>
#include <Protocol/HiiDatabase.h>
#include <Protocol/HiiPackageList.h>
#include <Protocol/DriverSupportedEfiVersion.h>
#include <Protocol/ComponentName2.h>
#include <Protocol/ComponentName.h>
#include <Protocol/HiiConfigAccess.h>

//
// Consumed Protocols
//
#include <Protocol/PciIo.h>

//
// Produced Protocols
//
#include <Protocol/SimpleTextOut.h>

//
// Guids
//

//
// Driver Version
//
#define DRIVER2_VERSION  0x00000000

//
// Protocol instances
//
extern EFI_DRIVER_BINDING_PROTOCOL  gdriver2DriverBinding;
extern EFI_COMPONENT_NAME2_PROTOCOL  gdriver2ComponentName2;
extern EFI_COMPONENT_NAME_PROTOCOL  gdriver2ComponentName;
extern EFI_HII_CONFIG_ACCESS_PROTOCOL  gdriver2HiiConfigAccess;

//
// Include files with function prototypes
//
#include "DriverBinding.h"
#include "ComponentName.h"
#include "HiiConfigAccess.h"
#include "SimpleTextOutput.h"

#endif
