#ifndef THREAD_H_INCLUDE
#define THREAD_H_INCLUDE

#include <winsock2.h>
#include <windows.h>
#include "stdio.h"

class Thread;

struct IRunnable {
	virtual int exec() = 0;
};

class Thread {
protected:
	static int WINAPI threadProc(LPVOID param)
	{
		Thread *pThis = (Thread*)param ;
		int ret = pThis->mRunObject->exec();
		printf("thread has expired...");
		return ret;
	}

public:

	Thread(IRunnable* runobj)
		: mRunObject(runobj)
		, mThread(NULL)
	{}

	int start(bool join)
	{
		mThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)Thread::threadProc, (LPVOID)this, 0, NULL);
		if (mThread <= 0) {
			printf("[Error] cannot create thread");
			return -1;
		}
		if (join) {
			WaitForSingleObject(mThread, INFINITE);
		}
		return 0;
	}

private:
	IRunnable* mRunObject ;
	HANDLE	   mThread;

};

#endif // THREAD_H_INCLUDE