#ifndef VPP_TEST_CASE_H_INCLUDE
#define VPP_TEST_CASE_H_INCLUDE


#include "mfxvideo.h"
#include "mfxvideo++.h"
#include "stdint.h"
#include "thread.h"
#include <vector>
#include <list>
#include <fstream>
#include <ctime>
#include <cstdlib>
#include <assert.h>

#ifndef INT32_MAX
#define INT32_MAX       0x7fffffff
#endif

#define MSDK_DEC_WAIT_INTERVAL 60000
#define MSDK_ENC_WAIT_INTERVAL 10000
#define MSDK_VPP_WAIT_INTERVAL 60000
#define MSDK_WAIT_INTERVAL MSDK_DEC_WAIT_INTERVAL+3*MSDK_VPP_WAIT_INTERVAL+MSDK_ENC_WAIT_INTERVAL

struct VideoStreamFormat {
	int    width;
	int    height;
	double frameRate;
	int    pixelFormat;
	int    picStruct;
};

class SurfPool {
public:
	int  alloc(const mfxFrameInfo& info, size_t size);
	void dealloc();
	mfxFrameSurface1* attachFreeSurf(const uint8_t* ptr);
private:
	std::vector<mfxFrameSurface1> mSurfArray;
};

class VppProc {
public:
	VppProc(const VideoStreamFormat& in, const VideoStreamFormat& out);
	~VppProc();
	int  open();
	void close();
	int  process(const uint8_t* pIn, uint8_t* pOut);
private:
	MFXVideoSession   mSession;
	MFXVideoVPP*      mVpp;
	mfxVideoParam     mVppParams;
	std::vector<mfxExtBuffer*> mVppExtParams;
	mfxExtVPPDoNotUse mVppDoNotUse;
	SurfPool          mSurfI;
	SurfPool          mSurfO;
};

class VppTestCase : public IRunnable {
public:
	VppTestCase(const char* file, const VideoStreamFormat& vf, const VideoStreamFormat& of);
	virtual int exec();
private:
	std::ifstream     mYUVFile;
	VppProc           mVpp;
	VideoStreamFormat mFmtIn;
	VideoStreamFormat mFmtOut;
};

class HeapTestCase : public IRunnable {
public:
	virtual int exec()
	{
		for (;;) {
			srand((unsigned)time(NULL));
			size_t size = rand()%256 * 1021;
			char* ptr = (char*)malloc(size);
			if (size)
				ptr[0] = 0xDA;
			ptrList.push_back(ptr);
			while (ptrList.size() > 256) {
				void* p = ptrList.front();
				ptrList.pop_front();
				free(p);
			}
		}
	}
	std::list<void*> ptrList;
};

#endif // VPP_TEST_CASE_H_INCLUDE